/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.io.FileFinder;
import de.willuhn.jameica.plugin.AbstractPluginSource;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PluginSourceUser
extends AbstractPluginSource {
    private List<File> dirs = null;

    @Override
    public PluginSource.Type getType() {
        return PluginSource.Type.USER;
    }

    @Override
    public synchronized List<File> find() {
        File[] pluginDirs;
        if (this.dirs != null) {
            return this.dirs;
        }
        this.dirs = new ArrayList<File>();
        File dir = this.getDir();
        Logger.info((String)("searching for " + this.getType() + " plugins in " + dir.getAbsolutePath()));
        for (File pluginDir : pluginDirs = new FileFinder(dir).findAll()) {
            if (!pluginDir.canRead() || !pluginDir.isDirectory()) {
                Logger.warn((String)("  skipping " + pluginDir.getAbsolutePath() + " - no directory or not readable"));
                continue;
            }
            Logger.info((String)("  adding " + pluginDir.getAbsolutePath()));
            this.dirs.add(pluginDir);
        }
        return this.dirs;
    }

    @Override
    public boolean canWrite() {
        return this.getDir().canWrite();
    }

    @Override
    public String getName() {
        return Application.getI18n().tr("Benutzer-Ordner (nur f\u00fcr aktuellen Benutzer)");
    }

    @Override
    public File getDir() {
        return Application.getConfig().getUserPluginDir();
    }
}

